#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_movsx16_O16regr2_I16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I16dsrm322D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I16rarm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I16rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I16rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I16rarm323(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I16rarm323D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I16rarm323D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I8dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I8dsrm322D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I8rarm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I8rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I8rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I8rarm323(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I8rarm323D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr2_I8rarm323D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16dsD16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16dsrm161(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16dsrm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16r1rm161D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16r1rm161D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16r2rm162(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16r2rm162D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16r2rm162D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I16regm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_READ_16BIT_REG((last&0x7));

arg0=(Bit16u)((Bit16s)((Bit16s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8dsD16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8dsrm161(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8dsrm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8r1rm161D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8r1rm161D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8r2rm162(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8r2rm162D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8r2rm162D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8reghm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_movsx16_O16regr_I8reglm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;

arg0=(Bit16u)((Bit16s)((Bit8s)arg1));
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}
